CREATE PROCEDURE App.NVCC_usp_GetOrCreateUser
	@UserName varchar(50)

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS

--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetOrCreateUser
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-29-2017
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To retrieve a corresponding record from App.NVCC_UsersV2
--                        or to create and return one if none exists. For this to
--                        work, all columns other that UserName must have default
--                        values.
--==================================================================================

BEGIN
	-- Derived from https://stackoverflow.com/a/1488387/892313
	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
	BEGIN TRANSACTION
		DECLARE @UserID int
		SELECT @UserID = UserId FROM App.NVCC_UsersV2 WHERE UserName = @UserName
		IF @UserID IS NULL
		BEGIN
			INSERT INTO App.NVCC_UsersV2 (UserName) VALUES (@UserName)
			SELECT @UserID = SCOPE_IDENTITY()
		END
		SELECT * FROM App.NVCC_UsersV2 WHERE UserId = @UserID
	COMMIT TRANSACTION
END

